@extends('layouts.master-customer')

@section('content')

    <!-- page content -->
    <div class="right_col" role="main">
        <div class="">
            <div class="page-title">
                <div class="title_left">
                    <h4> <a href="{{url('/customer')}}" class="fa fa-home"> Home</a> / <a href="{{url('/feedback')}}"> Feedback</a> </h4>
                </div>
            </div>
            <div class="clearfix"></div>

            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="x_title">
                            <h1>Feedback </h1>

                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">

                            <form action="{{url('/feedback/create')}}" method="post" class="form-horizontal form-label-left" novalidate>

                                <p>Give your opinion about all our service... Have a nice day <code class="fa fa-smile-o"></code>
                                </p>
                                <span class="section"></span>

                                @if(Session::has('alert-success'))
                                    <div class="alert alert-success">
                                        {{ Session::get('alert-success') }}
                                    </div>
                                @endif
                                @if(!empty($errors->first()))
                                    <div class='alert alert-warning'>{!! $errors->first() !!}</div>
                                @endif
                                    <form action="{{url('/feedback/store')}}" method="post" data-parsley-validate class="form-horizontal form-label-left">
                                        {{csrf_field()}}

                                        <div class="form-group{{ $errors->has('user_id') ? ' has-error' : '' }}">
                                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name" required >User ID
                                            </label>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <input type="text" name="user_id"  value="{{Sentinel::getUser()->id}}" class="form-control col-md-7 col-xs-12" readonly>
                                                {!! $errors->first('user_id', '<p class="help-block">:message</p>') !!}
                                            </div>
                                        </div>

                                        <div class="form-group{{ $errors->has('first_name') ? ' has-error' : '' }}">
                                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name" required >Customer Name
                                            </label>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <input type="text" name="first_name" value="{{Sentinel::getUser()->first_name}}"  class="form-control col-md-7 col-xs-12" readonly>
                                                {!! $errors->first('first_name', '<p class="help-block">:message</p>') !!}
                                            </div>
                                        </div>

                                        <div class="form-group{{ $errors->has('subjects') ? ' has-error' : '' }}">
                                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name" required >Subjects
                                                <span class="required">*</span>
                                            </label>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <input type="text" name="subjects" required="required" class="form-control col-md-7 col-xs-12">
                                                {!! $errors->first('subjects', '<p class="help-block">:message</p>') !!}
                                            </div>
                                        </div>

                                        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                            <label class="control-label col-md-3 col-sm-3 col-xs-12" for="first-name" required >Description
                                                <span class="required">*</span>
                                            </label>
                                            <div class="col-md-6 col-sm-6 col-xs-12">
                                                <textarea id="textarea" name="description" required="required" class="form-control col-md-7 col-xs-12"></textarea>
                                                {!! $errors->first('description', '<p class="help-block">:message</p>') !!}
                                            </div>
                                        </div>

                                        <div class="ln_solid"></div>
                                        <div class="form-group">
                                            <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-3">
                                                <button class="btn btn-primary" type="reset">Reset</button>
                                                <button type="submit" class="btn btn-success">Kirim</button>
                                            </div>
                                        </div>
                                </form>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /page content -->
@endsection