<!-- Left side column. contains the logo and sidebar -->
<aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">

        <!-- Sidebar user panel (optional) -->
        @if (! Auth::guest())
            <div class="user-panel">
                <div class="pull-left image">
                    <img src="{{ Gravatar::get($user->email) }}" class="img-circle" alt="User Image" />
                </div>
                <div class="pull-left info">
                    <p>{{ Auth::user()->name }}</p>
                    <!-- Status -->
                    <a href="#"><i class="fa fa-circle text-success"></i> {{ trans('adminlte_lang::message.online') }}</a>
                </div>
            </div>
        @endif

        <!-- Sidebar Menu -->
        <ul class="sidebar-menu">
            <li class="header"> MENU </li>
            <!-- Optionally, you can add icons to the links -->
            @if (Auth::user()->role == 'admin')
            <li><a href="{{ url('/user') }}"><i class='fa fa-user'></i> <span>User</span></a></li>
            <li><a href="{{ url('/class') }}"><i class='fa fa-group'></i> <span>Class</span></a></li>
            <li><a href="{{ url('/course') }}"><i class='fa fa-book'></i> <span>Courses</span></a></li>
            <li><a href="{{ url('/room') }}"><i class='fa fa-home'></i> <span>Room</span></a></li>
            <!-- <li class="treeview">
                <a href="#"><i class='fa fa-link'></i> <span>{{ trans('adminlte_lang::message.multilevel') }}</span> <i class="fa fa-angle-left pull-right"></i></a>
                <ul class="treeview-menu">
                    <li><a href="#">{{ trans('adminlte_lang::message.linklevel2') }}</a></li>
                    <li><a href="#">{{ trans('adminlte_lang::message.linklevel2') }}</a></li>
                </ul>
            </li> -->
            @else
            <li class="treeview">
                <a href="#"><i class='fa fa-paper-plane'></i> <span> Request </span></a>
                <ul class="treeview-menu">
                    <li><a href="{{ url('/request') }}">New Request</a></li>
                    <li><a href="{{ url('/request/canceled') }}">Canceled Request</a></li>
                    <li><a href="{{ url('/request/finished') }}">Finished Request</a></li>
                </ul>
            </li>
            <!-- <li><a href="{{ url('/request') }}"><i class='fa fa-paper-plane'></i> <span>Request</span></a></li> -->
            <li class="treeview">
                <a href="#"><i class='fa fa-hand-paper-o'></i> <span> Help </span></a>
                <ul class="treeview-menu">
                    <li><a href="{{ url('/help') }}">New Help</a></li>
                    <li><a href="{{ url('/help/accepted') }}">Approved Help</a></li>
                    <li><a href="{{ url('/help/finished') }}">Finished Help</a></li>
                </ul>
            </li>
            <!-- <li><a href="{{ url('/help') }}"><i class='fa fa-hand-paper-o'></i> <span>Need Help</span></a></li> -->
            <li class="treeview">
                <a href="#"><i class='fa fa-envelope'></i> <span> Invitation </span></a>
                <ul class="treeview-menu">
                    <li><a href="{{ url('/invitation') }}">New Invitation</a></li>
                    <li><a href="{{ url('/invitation/accepted') }}">Accepted Invitation</a></li>
                    <li><a href="{{ url('/invitation/rejected') }}">Rejected Invitation</a></li>
                </ul>
            </li>
            <!-- <li><a href="{{ url('/invitation') }}"><i class='fa fa-envelope'></i> <span>Invitation</span></a></li> -->
            @endif
        </ul><!-- /.sidebar-menu -->
    </section>
    <!-- /.sidebar -->
</aside>
