@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Room
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Room</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Room
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>ID</th>
					                        <th>Name</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($rooms as $room)
					                        <tr>
					                            <td>{{ $room->id }}</td>
					                            <td>{{ $room->name }}</td>
					                            <td> 
					                                <a href="{{ url('room/') }}/edit/{{$room->id}}" class="btn btn-primary"> Edit </a>
					                                <a href="{{ url('room/delete') }}/{{$room->id}} " class="btn btn-danger" onclick="return confirm('Are you sure to delete this data?')"> Delete </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					            {{ $rooms->render() }}
					        </div>
					        <a href="{{url('room/create')}}" class="btn btn-primary" role="button">Add room</a>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
