@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Request
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Your Request <b>(Remaining : {{2-$totalRequest}})</b>	</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Unapproved Request
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
					
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($UFrequests as $request)
					                        <tr>
					                            <td>{{ $request->course_name }}</td>
					                            <td>{{ $request->class_name }}</td>
					                            <td>{{ $request->due_date }}</td>
					                            <td>{{ $request->due_time }}</td>
					                            <td>{{ $request->room_name }}</td>
					                            <td>{{ $request->type }}</td>
					                            <td>{{ $request->totalAttender }}</td>
					                            <td>{{ $request->status }}</td>

					                            <td> 
					                                <a href="{{ url('request/') }}/edit/{{$request->id}}" class="btn btn-primary"> Edit </a>
					                                <a href="{{ url('request/cancel') }}/{{$request->id}} " class="btn btn-danger" onclick="return confirm('Are you sure to cancel this request?')"> Cancel </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					        </div>
					        @if($totalRequest < 2)
					        	<a href="{{url('request/create')}}" class="btn btn-primary" role="button">Add Request</a>
					        @endif
					    </div>
					</div>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of On Progress Request
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
											<th>Approver</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($Frequests as $request)
					                        <tr>
					                            <td>{{ $request->course_name }}</td>
					                            <td>{{ $request->class_name }}</td>
					                            <td>{{ $request->due_date }}</td>
					                            <td>{{ $request->due_time }}</td>
					                            <td>{{ $request->room_name }}</td>
					                            <td>{{ $request->type }}</td>
					                            <td>{{ $request->totalAttender }}</td>
					                            <td>{{ $request->status }}</td>
					                            <td>{{ $request->approverName }}</td>
					                            <td> 
					                                <a href="{{ url('request/') }}/done/{{$request->id}}" class="btn btn-primary"> Done </a>
					                                <a href="{{ url('request/cancel') }}/{{$request->id}} " class="btn btn-danger" onclick="return confirm('Are you sure to cancel this request?')"> Cancel </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					        </div>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
