@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Request
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Your Finished Request</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Finished Request
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
					                        <th>Approver</th>
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($UFrequests as $request)
					                        <tr>
					                            <td>{{ $request->course_name }}</td>
					                            <td>{{ $request->class_name }}</td>
					                            <td>{{ $request->due_date }}</td>
					                            <td>{{ $request->due_time }}</td>
					                            <td>{{ $request->room_name }}</td>
					                            <td>{{ $request->type }}</td>
					                            <td>{{ $request->totalAttender }}</td>
					                            <td>{{ $request->status }}</td>
					                            <td>{{ $request->approver_name }}</td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					        </div>
					    </div>
					    {{ $UFrequests->render() }}
					</div>
			</div>
		</div>
	</div>
@endsection
