@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Request
@endsection

@section('main-content')
    <script type="text/javascript">
        $(document).ready(function(){
            $("#datepicker").datepicker({
                autoclose : true,
                format: 'yyyy-dd-mm',
                startDate: '+4d'
            });
        });

        $(document).ready(function(){
            $("#timepicker").timepicker({
                showInputs: false,
                showMeridian: false
            });
        });
    </script>
	<div class="container-fluid spark-screen">
		<div class="row center">
            <div class="col-md-2">
                
            </div>
			<div class="col-md-8">
				<h2 class="page-header">Add Request</h2>
				<div class="register-box-body">
                <!-- <p class="login-box-msg">{{ trans('adminlte_lang::message.registermember') }}</p> -->
                <form action="{{ url('/request/store') }}" method="post">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                    <input type="hidden" name="class_id" value="{{ $class_id }}">

                    <input type="hidden" name="requester_id" value="{{ Auth::user()->id }}">
                    
                    <div class="form-group">
                        <select class="form-control" name="course_id">
                            @foreach ($courses as $course)
                                <option value="{{ $course->course_id }}"> {{ $course->name }} </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <select class="form-control" name="type">
                            <option value="Praktikum"> Praktikum </option>
                            <option value="Teori"> Teori </option>
                        </select>
                    </div>

                    <div class="form-group">
                        <select class="form-control" name="room_id">
                            @foreach ($rooms as $room)
                                <option value="{{ $room->id }}"> {{ $room->name }} </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group has-feedback">
                        <input type="text" class="form-control" placeholder="Date" name="due_date" id="datepicker"/>
                        <span class="fa fa-calendar form-control-feedback"></span>
                    </div> 

                    <div class="form-group has-feedback bootstrap-timepicker">
                        <input type="text" class="form-control timepicker" placeholder="Time" name="due_time" id="timepicker"/>
                        <span class="fa fa-clock-o form-control-feedback"></span>
                    </div>
                    
                    <div class="row">
                        <div class="col-xs-1">
                           
                        </div><!-- /.col -->
                        <div class="col-xs-6">
                        
                        </div><!-- /.col -->
                        <div class="col-xs-4 col-xs-push-1">
                            <button type="submit" class="btn btn-primary btn-block btn-flat">Add</button>
                        </div><!-- /.col -->
                    </div>
                </form>
            </div>
			</div>
		</div>
	</div>
@endsection
