@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Help
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Your Friend's Requests</b>	</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Your Friend's Unfinish Requests
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                    	<th>Requester</th>
					                        <th>Course</th>
					                        <th>Class</th>
					                        <th>Date</th>
					                        <th>Time</th>
					                        <th>Room</th>
					                        <th>Type</th>
					                        <th>Attender</th>
					                        <th>Status</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($UFrequests as $request)
					                        <tr>
					                        	<td>{{ $request->requester }}</td>
					                            <td>{{ $request->course_name }}</td>
					                            <td>{{ $request->class_name }}</td>
					                            <td>{{ $request->due_date }}</td>
					                            <td>{{ $request->due_time }}</td>
					                            <td>{{ $request->room_name }}</td>
					                            <td>{{ $request->type }}</td>
					                            <td>{{ $request->totalAttender }}</td>
					                            <td>{{ $request->status }}</td>
					                            <td> 
					                                <a href="{{ url('help/accept') }}/{{$request->id}} " class="btn btn-primary" onclick="return confirm('Are you sure to accept this request?')"> Accept </a>
					                            </td>
					                        <tr>
					                    @endforeach

					                    
					                </tbody>
					            </table>
					        </div>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
