@extends('adminlte::layouts.app')

@section('htmlheader_title')
	Class
@endsection

@section('main-content')
	<div class="container-fluid spark-screen">
		<div class="row">
			<div class="col-md-12">
				<h2 class="page-header">Class</h2>

					<div class="panel panel-default">
					    <div class="panel-heading">
					        List of Classes
					    </div>

					    <div class="panel-body">
					        <div class="">
					            <table class="table table-striped" id="thegrid">
					                <thead>
					                    <tr>
					                        <th>ID</th>
					                        <th>Name</th>
					                        <th style="width:150px">Action</th>
					                        <!-- <th style="width:50px"></th> -->
					                    </tr>
					                </thead>
					                <tbody>
					                    @foreach ($classes as $class)
					                        <tr>
					                            <td>{{ $class->id }}</td>
					                            <td><a href="{{ url('class/show', $class->id)}}"> {{ $class->name }}</td>
					                            <td> 
					                                <a href="{{ url('class/') }}/edit/{{$class->id}}" class="btn btn-primary"> Edit </a>
					                                <a href="{{ url('class/delete') }}/{{$class->id}} " class="btn btn-danger" onclick="return confirm('Are you sure to delete this data?')"> Delete </a>
					                            </td>
					                        <tr>
					                    @endforeach
					                </tbody>
					            </table>
					            {{ $classes->render() }}
					        </div>
					        <a href="{{url('class/create')}}" class="btn btn-primary" role="button">Add Class</a>
					    </div>
					</div>
			</div>
		</div>
	</div>
@endsection
