/*

SQLyog Ultimate v8.6 Beta2
MySQL - 5.5.5-10.1.16-MariaDB : Database - dtrs2

*********************************************************************

*/



/*!40101 SET NAMES utf8 */;



/*!40101 SET SQL_MODE=''*/;



/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

CREATE DATABASE /*!32312 IF NOT EXISTS*/`dtrs2` /*!40100 DEFAULT CHARACTER SET latin1 */;



USE `dtrs2`;



/*Table structure for table `class_courses` */



DROP TABLE IF EXISTS `class_courses`;



CREATE TABLE `class_courses` (
  `class_id` int(10) unsigned NOT NULL,
  `course_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  KEY `class_courses_class_id_foreign` (`class_id`),
  KEY `class_courses_course_id_foreign` (`course_id`),
  CONSTRAINT `class_courses_class_id_foreign` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `class_courses_course_id_foreign` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `class_courses` */



insert  into `class_courses`(`class_id`,`course_id`) values (2,'IF421112'),(2,'IF421313'),(3,'IF411111'),(3,'IF411213'),(3,'IF411112'),(3,'IF411317'),(4,'IF421111'),(4,'IF421112'),(4,'IF421313'),(5,'IF421111'),(5,'IF421112'),(5,'IF421313'),(2,'IF411111'),(6,'IF411318');



/*Table structure for table `classes` */



DROP TABLE IF EXISTS `classes`;



CREATE TABLE `classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `classes` */



insert  into `classes`(`id`,`name`) values (1,'admin'),(2,'42TI'),(3,'41TI'),(4,'32TI'),(5,'32TK'),(6,'43TI'),(8,'33TI');



/*Table structure for table `courses` */



DROP TABLE IF EXISTS `courses`;



CREATE TABLE `courses` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `courses` */



insert  into `courses`(`id`,`name`) values ('IF411111','Bahasa Indonesia'),('IF411112','English I'),('IF411213','Discrete Math'),('IF411314','Introduction Informatic Technology'),('IF411315','Web Development'),('IF411316','Computer and Architecture Organization'),('IF411317','Basic Programming'),('IF411318','Operation System'),('IF421111','English III'),('IF421112','Pancasila and Civics'),('IF421313','Internet Based Application Development'),('IF421314','Object Oriented Programming'),('IF421316','Introduction Information System'),('IF421318','Interpersonal Communication'),('IF421342','English IV');



/*Table structure for table `invitations` */



DROP TABLE IF EXISTS `invitations`;



CREATE TABLE `invitations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `request_id` int(10) unsigned NOT NULL,
  `to_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` enum('Rejected','Accepted') COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invitations_request_id_foreign` (`request_id`),
  KEY `FK_invitations` (`to_id`),
  CONSTRAINT `FK_invitations` FOREIGN KEY (`to_id`) REFERENCES `users` (`id`),
  CONSTRAINT `invitations_request_id_foreign` FOREIGN KEY (`request_id`) REFERENCES `requests` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `invitations` */



insert  into `invitations`(`id`,`request_id`,`to_id`,`status`) values (1,1,'if415001','Accepted'),(2,1,'if415007','Accepted'),(3,2,'if415001','Accepted'),(4,2,'if415007',NULL),(5,3,'if415001',NULL),(6,3,'if415007','Accepted'),(7,4,'if415007',NULL),(8,4,'if415009','Accepted'),(9,6,'if415001',NULL),(10,6,'if415002',NULL),(11,6,'if415003',NULL),(12,6,'if415004',NULL),(13,6,'if415005',NULL),(14,6,'if415007',NULL),(15,6,'if415011',NULL),(16,6,'if415012',NULL),(17,6,'if415013',NULL),(18,6,'if415014',NULL),(19,6,'if415030',NULL),(20,6,'if415032',NULL),(21,6,'if416005',NULL),(22,7,'if415001','Accepted'),(23,7,'if415002',NULL),(24,7,'if415003',NULL),(25,7,'if415004',NULL),(26,7,'if415005',NULL),(27,7,'if415007','Accepted'),(28,7,'if415011',NULL),(29,7,'if415012',NULL),(30,7,'if415013',NULL),(31,7,'if415014',NULL),(32,7,'if415030',NULL),(33,7,'if415032',NULL),(34,7,'if416005',NULL),(35,8,'if415001',NULL),(36,8,'if415002',NULL),(37,8,'if415003',NULL),(38,8,'if415004',NULL),(39,8,'if415005',NULL),(40,8,'if415007',NULL),(41,8,'if415011',NULL),(42,8,'if415012',NULL),(43,8,'if415013',NULL),(44,8,'if415014',NULL),(45,8,'if415030',NULL),(46,8,'if415032',NULL),(47,8,'if416005',NULL),(48,9,'if415001',NULL),(49,9,'if415002',NULL),(50,9,'if415003',NULL),(51,9,'if415004',NULL),(52,9,'if415005',NULL),(53,9,'if415007',NULL),(54,9,'if415011',NULL),(55,9,'if415012',NULL),(56,9,'if415013',NULL),(57,9,'if415014',NULL),(58,9,'if415030',NULL),(59,9,'if415032',NULL),(60,9,'if416005',NULL),(61,10,'if415001',NULL),(62,10,'if415002',NULL),(63,10,'if415003','Accepted'),(64,10,'if415004',NULL),(65,10,'if415005',NULL),(66,10,'if415007',NULL),(67,10,'if415011',NULL),(68,10,'if415012',NULL),(69,10,'if415013',NULL),(70,10,'if415014',NULL),(71,10,'if415030',NULL),(72,10,'if415032',NULL),(73,10,'if416005',NULL);



/*Table structure for table `migrations` */



DROP TABLE IF EXISTS `migrations`;



CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `migrations` */



insert  into `migrations`(`id`,`migration`,`batch`) values (1,'2016_12_21_170738_create_all_tebels',1);



/*Table structure for table `requests` */



DROP TABLE IF EXISTS `requests`;



CREATE TABLE `requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `requester_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `approver_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `class_id` int(10) unsigned NOT NULL,
  `course_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `due_date` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `due_time` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `room_id` int(10) unsigned NOT NULL,
  `type` enum('Teori','Praktikum') COLLATE utf8_unicode_ci NOT NULL,
  `status` enum('Requested','Canceled','On Progress','Finish') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'Requested',
  `totalAttender` int(10) unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `requests_requester_id_foreign` (`requester_id`),
  KEY `requests_approver_id_foreign` (`approver_id`),
  KEY `requests_class_id_foreign` (`class_id`),
  KEY `requests_course_id_foreign` (`course_id`),
  KEY `FK_requests` (`room_id`),
  CONSTRAINT `FK_requests` FOREIGN KEY (`room_id`) REFERENCES `rooms` (`id`),
  CONSTRAINT `requests_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`id`),
  CONSTRAINT `requests_class_id_foreign` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`),
  CONSTRAINT `requests_course_id_foreign` FOREIGN KEY (`course_id`) REFERENCES `courses` (`id`),
  CONSTRAINT `requests_requester_id_foreign` FOREIGN KEY (`requester_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `requests` */



insert  into `requests`(`id`,`requester_id`,`approver_id`,`class_id`,`course_id`,`due_date`,`due_time`,`room_id`,`type`,`status`,`totalAttender`,`created_at`,`updated_at`) values (1,'if415009',NULL,2,'IF421313','2017-03-02','19:15',2,'Teori','Canceled',3,'2017-01-06 09:07:20','2017-01-06 02:07:20'),(2,'if415009','if415007',2,'IF421111','2017-26-01','20:00',1,'Praktikum','Finish',2,'2017-01-05 22:08:29','2017-01-05 15:08:29'),(3,'if415009','if415001',2,'IF421111','2017-11-01','09:00',1,'Praktikum','Finish',2,'2017-01-06 09:11:01','2017-01-06 02:11:01'),(4,'if415001','if415009',2,'IF421111','2017-20-01','09:00',1,'Praktikum','On Progress',2,'2017-01-23 17:02:12','2017-01-23 10:02:12'),(5,'if416001','if415001',3,'IF411111','2017-04-02','11:15',4,'Praktikum','On Progress',1,'2017-01-06 09:40:15','2017-01-06 02:40:15'),(6,'if415009','if415007',2,'IF421313','2017-10-01','12:00',3,'Teori','Finish',1,'2017-01-06 11:06:45','2017-01-06 04:06:45'),(7,'if415009','if415001',2,'IF421112','2017-03-02','11:00',3,'Teori','Finish',3,'2017-01-23 17:01:54','2017-01-23 10:01:54'),(8,'if415009',NULL,2,'IF421313','2017-02-02','11:15',3,'Praktikum','Canceled',1,'2017-01-23 17:01:51','2017-01-23 10:01:51'),(9,'if415009','if415003',2,'IF421313','2017-28-01','20:00',3,'Teori','Finish',1,'2017-01-23 17:08:28','2017-01-23 10:08:28'),(10,'if415009',NULL,2,'IF411111','2017-02-02','20:00',3,'Teori','Requested',2,'2017-01-23 17:09:47','2017-01-23 10:09:47');



/*Table structure for table `rooms` */



DROP TABLE IF EXISTS `rooms`;



CREATE TABLE `rooms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `rooms` */



insert  into `rooms`(`id`,`name`) values (1,'GD 711'),(2,'GD 712'),(3,'GD 713'),(4,'GD 714');



/*Table structure for table `users` */



DROP TABLE IF EXISTS `users`;



CREATE TABLE `users` (
  `id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `username` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `role` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `class_id` int(10) unsigned NOT NULL,
  `tutorCount` int(11) NOT NULL DEFAULT '0',
  `rating` decimal(3,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  UNIQUE KEY `users_id_unique` (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_class_id_foreign` (`class_id`),
  CONSTRAINT `users_class_id_foreign` FOREIGN KEY (`class_id`) REFERENCES `classes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



/*Data for the table `users` */



insert  into `users`(`id`,`name`,`username`,`email`,`password`,`role`,`class_id`,`tutorCount`,`rating`,`created_at`,`updated_at`,`remember_token`) values ('admin','Admin','admin','admin@dtrs.com','$2y$10$JFS2AA7hFQxOrDbH4O3EcuQbvPxBfeYXvuHpaEHfOiAKUdTlWq1ly','admin',1,0,'0.00',NULL,'2017-01-26 07:34:33','favmcpQ8WgzOQP1j4kOhxHBF3mL0H45lno5QRWwW2sjn63zirinpdUhGAT2p'),('if415001','Yolanda Hutajulu','if415001','if415001@students.del.ac.id','$2y$10$0bguWCDiGNS5X8SMa23aSurIZGO0wNKxIepVBQVy/okwM2oMHS9Lm','user',2,0,'0.00','2016-12-28 04:33:25','2017-01-06 04:11:31','rZazA7OxdvEZQCWqU1UzS83YX0jX0c6kKgc5Pov0L2iXZlO1pctu5vBxbQPI'),('if415002','Greace Situmorang','if415002','if415002@students.del.ac.id','$2y$10$nbDzCpt8bmzx4cps5dTiYuDcKCbq/P/AHjR.wBwjudhq8XR2WOrr2','user',2,0,'0.00','2017-01-06 02:57:17','2017-01-06 02:57:17',NULL),('if415003','Rizky Manurung','if415003','if415003@students.del.ac.id','$2y$10$zlgBZmQPR.onPnCR1eKMNu1es0DfqBmooWixinojOpUeR4km1ANxi','user',2,0,'0.00','2017-01-06 02:58:45','2017-01-23 10:02:36','JeRLRpkLGRXixYhUv0RkF5Dso59TxjutNTDVdIyip3TEhK4N9x8lX1sZ7IHm'),('if415004','Rinto Tambunan','if415004','if415004@students.del.ac.id','$2y$10$Ay4RLfhvI09UYmSDA7NpduWyewKgsO4LmQTjFx0UgTQ8RGp2t8Sk.','user',2,0,'0.00','2017-01-06 02:59:53','2017-01-06 02:59:53',NULL),('if415005','Pratiwi Okuli Manik','if415005','if415005@students.del.ac.id','$2y$10$4wFkoweDGWVX9xR4JvsfCOe8b0tRmPcd1azmeGo/PJHGd1RYZ6aBm','user',2,0,'0.00','2017-01-06 03:00:49','2017-01-06 03:00:49',NULL),('if415007','Winda Sianipar','if415007','if415007@students.del.ac.id','$2y$10$r1GICSMCRzKS65tdgy0tA.HB5g5b4lEz5zIFHoBNLXc98UrpTEFnG','user',2,0,'0.00','2017-01-05 08:08:22','2017-01-06 04:09:44','mL1q0stQVwoq7tG3p1BBFsa29gewlCvVZmQ9sGrSeUpZQ8Ex4RCEmbv2o28N'),('if415009','Eko Simanjuntak','if415009','ecojuntak@gmail.com','$2y$10$mzQStHdEtt6fYXdkisOc1.UEHgtxsDiGfprD9dDxc60VN2DmtKWE6','admin',1,0,'0.00',NULL,'2017-01-25 02:53:12','Qm0Lu9CokkAQJOfB7k4ORdzGNl3sKfMiD7wIjCctnsTpwhY4FNB3n4Pzjcf7'),('if415011','Jhon Charles Sipahutar','if415011','if415011@students.del.ac.id','$2y$10$1nLhOen8NuTCs42S4.43f.zGILyqgJIXKk9hPJU370M4n4uppzo1.','user',2,0,'0.00','2017-01-06 03:03:36','2017-01-06 03:03:36',NULL),('if415012','Irene Panjaitan','if415012','if415012@students.del.ac.id','$2y$10$KfOGMPf40b0vm0HetxNPde.69s4OAC9ab0gsACeS5gEdQ2IGeFnnW','user',2,0,'0.00','2017-01-06 03:02:50','2017-01-06 03:02:50',NULL),('if415013','Joel Wiranto Marpaung','if415013','if415013@students.del.ac.id','$2y$10$mMij6gvtx2PUOo.2QYq3uu4xzN9Ci6OvZEmdnT3L0QKbTiyA6t/I.','user',2,0,'0.00','2017-01-06 03:46:30','2017-01-06 03:46:30',NULL),('if415014','Juliper Simanjuntak','if415014','if415014@students.del.ac.id','$2y$10$rEt3YqJZkWR/JIwcNl4WmOPfi2UOGLx1rzwgVAakdScLF1f2V5i9W','user',2,0,'0.00','2017-01-06 03:47:27','2017-01-06 03:47:27',NULL),('if415030','Arren Rediman Yosafat Situngkir','if415030','if415030@students.del.ac.id','$2y$10$.018CWIzP/IMCZXqro2ZaOElWw2psA7q3ZkRySq9xssE.3E8EI88i','user',2,0,'0.00','2017-01-06 02:55:03','2017-01-06 02:55:03',NULL),('if415032','Rahel Purba','if415032','if415032@students.del.ac.id','$2y$10$GHKdLbUZV.cBYS/fkAPoe.ZZQdR2Atz/1qlERMYAhKo.Pe7LpDdIi','user',2,0,'0.00','2017-01-06 02:56:12','2017-01-06 02:56:12',NULL),('if415034','Amendo Mariesto Sitinjak','if415034','if415034@students.del.ac.id','$2y$10$4yRqM2HXzF/RO.6QsiaFjeIu5esEddXv3Uktps.G9UCdasW4M9AAy','user',1,0,'0.00','2017-01-06 03:28:57','2017-01-06 03:31:40',NULL),('if416001','Susi Puja','if416001','if416001@students.del.ac.id','$2y$10$gTSmi0SI9vfTeYj.7fBdC.WYqKJYlpmY5aRV7acbg0e0F357L4VH2','user',3,0,'0.00','2017-01-06 02:34:24','2017-01-06 03:57:11','lgo33gG1OFLrdd93tstHTKz6DFX7smJ6cyjeUDDV5CXi67J5u2xGaeFeN9aF'),('if416005','Juminten','if416005','if416005@students.del.ac.id','$2y$10$bvCO58UP2Qnd9ElLvOsVVOIfw8Kql5fsBV95kRGN2MnZaC1ygS.FS','user',2,0,'0.00','2017-01-06 03:05:16','2017-01-06 03:33:39',NULL);



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;

/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;

/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;

/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

