<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAllTebels extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('classes', function(Blueprint $table){
            $table->increments('id');
            $table->string('name' ,50);
        });
        
        Schema::create('courses', function(Blueprint $table){
            $table->string('id', 50);
            $table->string('name', 50);
            $table->primary('id');
        });

        Schema::create('class_courses', function(Blueprint $table){
            $table->integer('class_id')->unsigned();
            $table->string('course_id');
            $table->foreign('class_id')
                  ->references('id')
                  ->on('classes')
                  ->onDelete('cascade');
            $table->foreign('course_id')
                  ->references('id')
                  ->on('courses')
                  ->onDelete('cascade');
        });

        Schema::create('rooms', function(Blueprint $table){
            $table->increments('id');
            $table->string('name', 50);
        });

        Schema::create('users', function(Blueprint $table) {
            $table->string('id')->unique();
            $table->string('name', 50);
            $table->string('username', 50);
            $table->string('email', 50)->unique();
            $table->string('password', 255);
            $table->string('role');
            $table->integer('class_id')->unsigned();
            $table->foreign('class_id')
                  ->references('id')
                  ->on('classes');
            $table->integer('tutorCount')->default(0);
            $table->decimal('rating', 3, 2)->default(0);
            $table->timestamps();
            $table->rememberToken();
        });

        Schema::create('requests', function(Blueprint $table){
            $table->increments('id');
            $table->string('requester_id');
            $table->foreign('requester_id')
                  ->references('id')
                  ->on('users');
            $table->string('approver_id')->nullable();
            $table->foreign('approver_id')
                  ->references('id')
                  ->on('users');
            $table->integer('class_id')->unsigned();
            $table->foreign('class_id')
                  ->references('id')
                  ->on('classes');
            $table->integer('room_id')->unsigned();
            $table->foreign('room_id')
                  ->references('id')
                  ->on('rooms');
            $table->string('course_id', 50);
            $table->foreign('course_id')
                  ->references('id')
                  ->on('courses');
            $table->string('due_date');
            $table->string('due_time');
            $table->enum('type', ['Teori', 'Praktikum']);
            $table->enum('status', ['Requested', 'Canceled', 'On Progress', 'Finish'])->default('Requested');
            $table->integer('totalAttender')->unsigned()->default(1);
            $table->timestamp('created_at');
        });

        Schema::create('invitations', function(Blueprint $table){
            $table->increments('id');
            $table->integer('request_id')->unsigned();
            $table->foreign('request_id')
                  ->references('id')
                  ->on('requests');
            $table->string('approver_id');
            $table->foreign('approver_id')
                  ->references('id')
                  ->on('users');
            $table->enum('status', ['Rejected', 'Accepted'])->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('classes');
        Schema::dropIfExists('courses');
        Schema::dropIfExists('class_courses');
        Schema::dropIfExists('rooms');
        Schema::dropIfExists('users');
        Schema::dropIfExists('requests');
    }
}
