<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Requests;
use App\Course;
use App\Room;
use Auth;
use DB;

class RequestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                           ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                           ->join('classes', 'classes.id', '=', 'requests.class_id')
                                           ->join('users', 'users.id', '=', 'requests.requester_id')
                                           ->where('requester_id', $user_id)
                                           ->where('status', 'Requested')
                                           ->get(array('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name'));

        $Frequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                          ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                          ->join('classes', 'classes.id', '=', 'requests.class_id')
                                          ->join('users', 'users.id', '=', 'requests.approver_id')
                                          ->where('requester_id', $user_id)
                                          ->where('status', 'On Progress')
                                          ->get(array('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name', 'users.name as approverName'));

        $totalRequest = DB::table('requests')->whereIn('status', ['Requested','On Progress'])
                                             ->where('requester_id', $user_id)
                                             ->count();                                      

        return view('requests.index')->with('UFrequests', $UFrequests)
                                     ->with('Frequests', $Frequests)
                                     ->with('totalRequest', $totalRequest);
    }

    public function cancelled(){
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                          ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                          ->join('classes', 'classes.id', '=', 'requests.class_id')
                                          ->where('requester_id', $user_id)
                                          ->where('status', '=', 'Canceled')
                                          ->select('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name')
                                          ->paginate(10);

        return view('requests.cancelled')->with('UFrequests', $UFrequests);
    }

    public function finished(){
        $user_id = Auth::user()->id;
        $UFrequests = DB::table('requests')->join('courses', 'courses.id', '=', 'requests.course_id')
                                           ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                           ->join('classes', 'classes.id', '=', 'requests.class_id')
                                           ->join('users', 'users.id', '=', 'requests.approver_id')
                                           ->where('requester_id', $user_id)
                                           ->where('status', '=', 'Finish')
                                           ->select('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name',  'users.name as approver_name')
                                           ->paginate(10);

        return view('requests.finished')->with('UFrequests', $UFrequests);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $class_id = Auth::user()->class_id;
        $courses = DB::table('courses')->join('class_courses', 'courses.id', '=', 'class_courses.course_id')
                                       ->where('class_id',$class_id)
                                       ->get();
        $rooms = DB::table('rooms')->get();
        
        $class_id = Auth::user()->class_id;
        return view('requests.add')->with('courses', $courses)
                                   ->with('rooms', $rooms)
                                   ->with('class_id', $class_id);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $datas = $request->all();

        $class_id = $datas['class_id'];

        $request = new Requests;
        $request->requester_id = $datas['requester_id'];
        $request->class_id = $datas['class_id'];
        $request->course_id = $datas['course_id'];
        $request->due_date = $datas['due_date'];
        $request->due_time = $datas['due_time'];
        $request->type = $datas['type'];
        $request->room_id = $datas['room_id'];
        $request->type = $datas['type'];
        $request->save();

        $lastID = DB::table('requests')->orderBy('id','desc')->limit(1)->get(array('id'));

        InvitationController::store($lastID, $class_id);

        return redirect('/request');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $request = Requests::find($id);
        $class_id = Auth::user()->class_id;
        $courses = DB::table('courses')->join('class_courses', 'courses.id', '=', 'class_courses.course_id')
                                       ->where('class_id',$class_id)
                                       ->get();
        $rooms = DB::table('rooms')->get();
        
        $class_id = Auth::user()->class_id;

        return view('requests.edit')->with('courses', $courses)
                                   ->with('rooms', $rooms)
                                   ->with('class_id', $class_id)
                                   ->with('request', $request);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $datas = $request->all();

        $request = Requests::find($id);
        $request->requester_id = $datas['requester_id'];
        $request->class_id = $datas['class_id'];
        $request->course_id = $datas['course_id'];
        $request->due_date = $datas['due_date'];
        $request->due_time = $datas['due_time'];
        $request->type = $datas['type'];
        $request->room_id = $datas['room_id'];
        $request->type = $datas['type'];
        $request->save();

        return redirect('/request');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function cancel($id){
        $request = Requests::find($id);

        $request->status = 'Canceled';
        $request->update();

        return redirect('/request');
    }

    public function done($id){
        $request = Requests::find($id);

        $request->status = 'Finish';
        $request->update();

        return redirect('/request');
    }
}
