<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Invitation;
use App\Requests;
use DB;
use Auth;

class InvitationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $UFinvitations = DB::table('invitations')->join('requests', 'requests.id' , '=', 'invitations.request_id')
                                                 ->join('classes', 'classes.id', '=', 'requests.class_id')
                                                 ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                                 ->join('courses', 'courses.id', '=', 'requests.course_id')
                                                 ->join('users', 'users.id', '=', 'requests.requester_id')
                                                 ->where('to_id', Auth::user()->id)
                                                 ->where('invitations.status', NULL)
                                                 ->whereIn('requests.status', ['Requested','On Progress'])
                                                 ->get(array('rooms.name as room_name',
                                                             'courses.name as course_name', 
                                                             'requests.*', 
                                                             'classes.name as class_name', 
                                                             'users.name as requester', 
                                                             'invitations.status as invitStatus', 
                                                             'invitations.id as invitID'));

        $Finvitations = DB::table('invitations')->join('requests', 'requests.id' , '=', 'invitations.request_id')
                                                ->join('classes', 'classes.id', '=', 'requests.class_id')
                                                ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                                ->join('courses', 'courses.id', '=', 'requests.course_id')
                                                ->join('users as requester', 'requester.id', '=', 'requests.requester_id')
                                                ->where('to_id', Auth::user()->id)
                                                ->where('invitations.status', 'Accepted')
                                                ->where('requests.status', 'Requested')
                                                ->select(array('rooms.name as room_name',
                                                               'courses.name as course_name', 
                                                               'requests.*', 
                                                               'classes.name as class_name', 
                                                               'requester.name as requester', 
                                                               'invitations.status as invitStatus', 
                                                               'invitations.id as invitID'))
                                                ->paginate(10);

        $FinvitationsAp = DB::table('invitations')->join('requests', 'requests.id' , '=', 'invitations.request_id')
                                                  ->join('classes', 'classes.id', '=', 'requests.class_id')
                                                  ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                                  ->join('courses', 'courses.id', '=', 'requests.course_id')
                                                  ->join('users as requester', 'requester.id', '=', 'requests.requester_id')
                                                  ->join('users as approver', 'approver.id', '=', 'requests.approver_id')
                                                  ->where('to_id', Auth::user()->id)
                                                  ->where('invitations.status', 'Accepted')
                                                  ->whereIn('requests.status', ['Requested','On Progress'])
                                                  ->select(array('rooms.name as room_name',
                                                               'courses.name as course_name', 
                                                               'requests.*', 
                                                               'classes.name as class_name', 
                                                               'requester.name as requester', 
                                                               'invitations.status as invitStatus', 
                                                               'invitations.id as invitID',
                                                               'approver.name as approver'))
                                                ->paginate(10);
        // dd($Finvitations);
        return view('invitations.index')->with('UFinvitations', $UFinvitations)
                                        ->with('Finvitations', $Finvitations)
                                        ->with('FinvitationsAp', $FinvitationsAp);
    }

    public function accepted(){
        $Finvitations = DB::table('invitations')->join('requests', 'requests.id' , '=', 'invitations.request_id')
                                                ->join('classes', 'classes.id', '=', 'requests.class_id')
                                                ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                                ->join('courses', 'courses.id', '=', 'requests.course_id')
                                                ->join('users as requester', 'requester.id', '=', 'requests.requester_id')
                                                ->join('users as approver', 'approver.id', '=', 'requests.approver_id')
                                                ->where('to_id', Auth::user()->id)
                                                ->where('invitations.status', 'Accepted')
                                                ->select(array('rooms.name as room_name',
                                                               'courses.name as course_name',
                                                               'requests.*', 
                                                               'classes.name as class_name', 
                                                               'requester.name as requester', 
                                                               'invitations.status as invitStatus', 
                                                               'invitations.id as invitID',
                                                               'approver.name as approver'))
                                                ->paginate(10);

        return view('invitations.accepted')->with('Finvitations', $Finvitations);
    }

    public function rejected(){
        $Finvitations = DB::table('invitations')->join('requests', 'requests.id' , '=', 'invitations.request_id')
                                                ->join('classes', 'classes.id', '=', 'requests.class_id')
                                                ->join('rooms', 'rooms.id', '=', 'requests.room_id')
                                                ->join('courses', 'courses.id', '=', 'requests.course_id')
                                                ->join('users', 'users.id', '=', 'requests.requester_id')
                                                ->where('to_id', Auth::user()->id)
                                                ->where('invitations.status', 'Rejected')
                                                ->select(array('rooms.name as room_name','courses.name as course_name', 'requests.*', 'classes.name as class_name', 'users.name as requester', 'invitations.status as invitStatus', 'invitations.id as invitID'))
                                                ->paginate(10);

        return view('invitations.rejected')->with('Finvitations', $Finvitations);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    static function store($lastRequest, $class_id)
    {
        $allNIM = DB::table('users')->where('class_id', $class_id)
                                    ->get(array('id'));

        $request = $lastRequest[0];

        foreach ($allNIM as $NIM) {
            if($NIM->id == Auth::user()->id){
                continue;
            }

            $invit = new Invitation;
            $invit->request_id = $request->id;
            $invit->to_id = $NIM->id;
            $invit->save();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function accept($id){
        $invitation = Invitation::find($id);
        
        $request_id = $invitation->request_id;
        
        $invitation->status = 'Accepted';
        $invitation->update();

        $request = Requests::find($request_id);
        $request->totalAttender += 1;
        // dd($request);
        $request->update();
        


        return redirect('/invitation');
    }

    public function reject($id){
        $invitation = Invitation::find($id);
        
        $invitation->status = 'Rejected';
        $invitation->update();

        return redirect('/invitation');
    }
}
