<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Classes;
use App\Course;
use App\ClassCourse;

class ClassController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('classes.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $datas = $request->all();

        $class = new Classes;
        $class->name = $datas['name'];
        $class->save();

        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $courses = DB::table('courses')->join('class_courses', 'courses.id', '=', 'class_courses.course_id')
                                       ->where('class_id',$id)
                                       ->get();
        $class = Classes::find($id);
        // dd($courses);
        return view('classes.show')->with('courses', $courses)
                                   ->with('class', $class);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $class = new Classes;
        $class = Classes::find($id);
        // dd($class);
        return view('classes.edit')->with('class', $class);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $class = Classes::where('id',$id)->first();
        $class->name = $request['name'];
        $class->update();

        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Classes::findOrFail($id);

        $data->delete();

        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }

    public function add($id){
        $courses = DB::table('courses')->get();

        return view('classes.assign')->with('courses', $courses)
                                  ->with('id', $id);
    }

    public function assign(Request $request){
        DB::table('class_courses')->insert(
            [
                'class_id' => $request['class_id'], 'course_id' => $request['course_id']
            ]
        );

        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }

    public function resign($class_id, $course_id){
        $data = DB::table('class_courses')->where('class_id', '=', $class_id)
                                          ->where('course_id', '=', $course_id);

        $data->delete();

        $classes = DB::table('classes')->paginate(10);
        return view('classes.index')->with('classes', $classes);
    }
}
