<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use File;
use App\Models\Pemesanan;
use App\Models\Bus;
use App\Models\Batal;
use App\Models\Users;
use Image;
Use App\Models\OrderTemp;
Use App\Models\Order;

class KlienController extends Controller
{
    public function pesan(){
        $key = Input::get('search');
        $this->data['title'] = 'Pesan Bus IT Del';
        return view('klien.pesan.index',$this->data);
    }

    public function pemesanan(Request $request){
        $input = $request->all();
        Pemesanan::create($input);
        return redirect(url('/klien'))->with('info','Data Bus berhasil ditambah');
    }

    public function bus(){
        $key = Input::get('search');
        $this->data['title'] = 'Bus IT Del';
        if(isset($key)){
            $this->data['bus'] = Bus::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['bus'] = Bus::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('bus')->get();
        return view('klien.bus.index',$this->data);
    }

    public function pilih(){
        $key = Input::get('search');
        $this->data['title'] = 'Bus IT Del';
        if(isset($key)){
            $this->data['bus'] = Bus::where('nama_bus','like','%'.$key.'%')->orderBy('id','desc')->paginate(10);
        }else{
            $this->data['bus'] = Bus::orderBy('id','desc')->paginate(10);
        }
        $this->data['total'] = DB::table('bus')->get();
        return view('klien.pesan.pilih',$this->data);
    }

    public function detail($id){
        $this->data['title'] = 'Detail Bus';
        $this->data['bus'] = Bus::find($id);
        return view('klien.bus.detail',$this->data);
    }

    public function history(){
        $username = Auth::user()->username;
        $users = DB::table('users')->where('username' , $username)->first();
        $id = $users->id;
        $this->data['title'] = 'History Pemesanan';
        $this->data['users'] = Users::find($id);

        $this->data['history'] = DB::table('batal')->where('client_username' , $username)->orderBy('id','desc')->paginate(10);
        $this->data['total'] = DB::table('batal')->where('client_username' , $username)->get();
        $this->data['status'] = DB::table('pemesanan')->where('client_username' , $username)->orderBy('id','desc')->paginate(10);
        $this->data['total'] = DB::table('pemesanan')->where('client_username' , $username)->get();
        return view('klien.history.index',$this->data);
    }

    public  function status(){
        $username = Auth::user()->username;
        $users = DB::table('users')->where('username' , $username)->first();
        $id = $users->id;
        $this->data['title'] = 'Status Pemesanan';
        $this->data['users'] = Users::find($id);

        $this->data['status'] = DB::table('pemesanan')->where('client_username' , $username)->orderBy('id','desc')->paginate(10);
        $this->data['total'] = DB::table('pemesanan')->where('client_username' , $username)->get();
        return view('klien.status.index',$this->data);
    }

    public function pilih_bus($id){
        $key = Input::get('search');
        $this->data['bus'] = Bus::find($id);
        $this->data['title'] = 'Pilih Bus IT Del';
        return view('klien.pesan.pilih_bus',$this->data);
    }

    public function batal($id){
        $this->data['title'] = 'Detail Pemesanan';
        $this->data['pemesanan'] = Pemesanan::find($id);
        pemesanan::find($id)->delete();
        return view('klien.status.batal',$this->data);
    }

    public function kirim_pembatalan(Request $request){
        $input = $request->all();
        Batal::create($input);
        return redirect(url('/klien'))->with('info','Pembatalan Berhasil dilakukan');
    }
}
