<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\bhsx\models\PesertaToefl */

$this->title = $model->peserta_toefl_id;
$this->params['breadcrumbs'][] = ['label' => 'Peserta Toefls', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="peserta-toefl-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->peserta_toefl_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->peserta_toefl_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'peserta_toefl_id',
            'use__id',
            'nama_peserta',
            'tanggal_lahir',
            'alamat:ntext',
            'telp',
            'email:email',
            'membership',
            'sumber_informasi',
            'tanggal_ujian',
            'tujuan_toefl',
            'pengambilan_hasil',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
            'deleted',
            'deleted_at',
            'deleted_by',
        ],
    ]) ?>

</div>
