<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model backend\modules\bhsx\models\PesertaKompetisi */

$this->title = $model->peserta_kompetisi_id;
$this->params['breadcrumbs'][] = ['label' => 'Peserta Kompetisis', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="peserta-kompetisi-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->peserta_kompetisi_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->peserta_kompetisi_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'peserta_kompetisi_id',
            'user_has_role_id',
            'nama_peserta',
            'tanggal_lahir',
            'jenis_kelamin',
            'telp',
            'asal_sekolah',
            'alamat_sekolah:ntext',
            'kompetisi_id',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
            'deleted',
            'deleted_at',
            'deleted_by',
        ],
    ]) ?>

</div>
