<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_r_peserta_kompetisi".
 *
 * @property integer $peserta_kompetisi_id
 * @property integer $user_has_role_id
 * @property string $nama_peserta
 * @property string $tanggal_lahir
 * @property string $jenis_kelamin
 * @property string $telp
 * @property string $asal_sekolah
 * @property string $alamat_sekolah
 * @property integer $kompetisi_id
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxPembayaranKompetisi[] $bhsxPembayaranKompetisis
 * @property BhsxPemenangKompetisi[] $bhsxPemenangKompetisis
 * @property BhsxRKategoriKompetisi $kompetisi
 * @property BhsxUserHasRole $userHasRole
 * @property BhsxSkor[] $bhsxSkors
 */
class PesertaKompetisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_r_peserta_kompetisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'nama_peserta', 'tanggal_lahir', 'jenis_kelamin', 'telp', 'asal_sekolah', 'alamat_sekolah', 'kompetisi_id'], 'required'],
            [['user_has_role_id', 'kompetisi_id', 'deleted'], 'integer'],
            [['tanggal_lahir', 'created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['alamat_sekolah'], 'string'],
            [['nama_peserta', 'asal_sekolah'], 'string', 'max' => 40],
            [['jenis_kelamin'], 'string', 'max' => 10],
            [['telp'], 'string', 'max' => 25],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['kompetisi_id'], 'exist', 'skipOnError' => true, 'targetClass' => KategoriKompetisi::className(), 'targetAttribute' => ['kompetisi_id' => 'kompetisi_id']],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'user_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'peserta_kompetisi_id' => 'Peserta Kompetisi ID',
            'user_id' => 'User ID',
            'nama_peserta' => 'Nama Peserta',
            'tanggal_lahir' => 'Tanggal Lahir',
            'jenis_kelamin' => 'Jenis Kelamin',
            'telp' => 'Telp',
            'asal_sekolah' => 'Asal Sekolah',
            'alamat_sekolah' => 'Alamat Sekolah',
            'kompetisi_id' => 'Kompetisi ID',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPembayaranKompetisis()
    {
        return $this->hasMany(PembayaranKompetisi::className(), ['peserta_kompetisi_id' => 'peserta_kompetisi_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPemenangKompetisis()
    {
        return $this->hasMany(PemenangKompetisi::className(), ['peserta_kompetisi_id' => 'peserta_kompetisi_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getKompetisi()
    {
        return $this->hasOne(KategoriKompetisi::className(), ['kompetisi_id' => 'kompetisi_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['user_id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSkors()
    {
        return $this->hasMany(Skor::className(), ['peserta_kompetisi_id' => 'peserta_kompetisi_id']);
    }
}
