<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_forum".
 *
 * @property integer $forum_id
 * @property integer $dosen_id
 * @property string $nama_dosen
 * @property string $judul_forum
 * @property string $isi_forum
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property HrdxDosen $dosen
 * @property BhsxKomentar[] $bhsxKomentars
 */
class Forum extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_forum';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['dosen_id', 'nama_dosen', 'judul_forum', 'isi_forum'], 'required'],
            [['dosen_id', 'deleted'], 'integer'],
            [['isi_forum'], 'string'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['nama_dosen', 'judul_forum'], 'string', 'max' => 40],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
            [['dosen_id'], 'exist', 'skipOnError' => true, 'targetClass' => Dosen::className(), 'targetAttribute' => ['dosen_id' => 'dosen_id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'forum_id' => 'Forum ID',
            'dosen_id' => 'Dosen ID',
            'nama_dosen' => 'Nama Dosen',
            'judul_forum' => 'Judul Forum',
            'isi_forum' => 'Isi Forum',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDosen()
    {
        return $this->hasOne(Dosen::className(), ['dosen_id' => 'dosen_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getKomentars()
    {
        return $this->hasMany(Komentar::className(), ['forum_id' => 'forum_id']);
    }
}
