<?php

namespace backend\modules\bhsx\models;

use Yii;

/**
 * This is the model class for table "bhsx_r_divisi".
 *
 * @property integer $divisi_id
 * @property string $nama_divisi
 * @property string $deskripsi
 * @property string $jumlah_anggota
 * @property string $created_at
 * @property string $updated_at
 * @property string $created_by
 * @property string $updated_by
 * @property integer $deleted
 * @property string $deleted_at
 * @property string $deleted_by
 *
 * @property BhsxDimHasDivisi[] $bhsxDimHasDivisis
 * @property BhsxDosenHasDivisi[] $bhsxDosenHasDivisis
 */
class Divisi extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'bhsx_r_divisi';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['nama_divisi', 'deskripsi', 'jumlah_anggota'], 'required'],
            [['created_at', 'updated_at', 'deleted_at'], 'safe'],
            [['deleted'], 'integer'],
            [['nama_divisi', 'deskripsi'], 'string', 'max' => 40],
            [['jumlah_anggota'], 'string', 'max' => 100],
            [['created_by', 'updated_by'], 'string', 'max' => 45],
            [['deleted_by'], 'string', 'max' => 32],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'divisi_id' => 'Divisi ID',
            'nama_divisi' => 'Nama Divisi',
            'deskripsi' => 'Deskripsi',
            'jumlah_anggota' => 'Jumlah Anggota',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'deleted' => 'Deleted',
            'deleted_at' => 'Deleted At',
            'deleted_by' => 'Deleted By',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDimHasDivisis()
    {
        return $this->hasMany(DimHasDivisi::className(), ['divisi_id' => 'divisi_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDosenHasDivisis()
    {
        return $this->hasMany(DosenHasDivisi::className(), ['divisi_id' => 'divisi_id']);
    }
}
