
@extends('layouts.master')

@section('header-in')
    <h4 class="page-title">Tulis Anggaran</h4> </div>
    
    <ol class="breadcrumb">
        <li><a href="{{ url('/bagren') }}">Dashboard</a></li>
        <li class="active">Tulis Anggaran</li>
    </ol>
@stop

@section('navigation')
    <ul class="nav" id="side-menu">
        <li style="padding: 10px 0 0;">
            <a href="{{ url('/bagren') }}" class="waves-effect"><i class="fa fa-user fa-fw" aria-hidden="true"></i><span class="hide-menu">Dashboard</span></a>
        </li>
        <li style="padding: 10px 0 0;">
            <a href="{{ url('/bagren/tulis_anggaran') }}" class="waves-effect"><i class="fa fa-user fa-fw" aria-hidden="true"></i><span class="hide-menu">Tulis Anggaran</span></a>
        </li>
        <li style="padding: 10px 0 0;">
            <a href="{{ url('/bagren/anggaran') }}" class="waves-effect"><i class="fa fa-user fa-fw" aria-hidden="true"></i><span class="hide-menu">Anggaran</span></a>
        </li>
        <li style="padding: 10px 0 0;">
            <a href="{{ url('/bagren/laporan') }}" class="waves-effect"><i class="fa fa-user fa-fw" aria-hidden="true"></i><span class="hide-menu">Laporan</span></a>
        </li>
        <li style="padding: 10px 0 0;">
            <a href="{{ url('/bagren/perencanaan') }}" class="waves-effect"><i class="fa fa-user fa-fw" aria-hidden="true"></i><span class="hide-menu">Perencanaan</span></a>
        </li>
    </ul>
@stop

@section('row1')
<form class="form-horizontal" role="form" method="POST" action="{{ url('bagren/anggaran/save') }}">
        {{ csrf_field() }}
    <div class="col-sm-12">
        <div class="white-box">
        <div class="form-horizontal" id="sample-form" style="display: block;">
            <div class="form-group{{ $errors->has('pemasukan') ? 'has-error' : '' }}">
                <label for="inputWarning" class="col-xs-12 col-sm-3 control-label no-padding-right">Pemasukan (Rp)</label>
                <div class="col-xs-12 col-sm-5">
                    <span class="block input-icon input-icon-right">
                        <input type="text" class="width-100 form-control" name="pemasukan" value=0>
                    </span>
                </div>
            </div>

            <div class="form-group{{ $errors->has('sumber') ? 'has-error' : '' }}">
                <label for="inputWarning" class="col-xs-12 col-sm-3 control-label no-padding-right">Sumber</label>
                <div class="col-xs-12 col-sm-5">
                    <span class="block input-icon input-icon-right">
                        <input type="text" class="width-100 form-control" name="sumber" value="-">
                    </span>
                </div>
            </div>

            <div class="form-group{{ $errors->has('pengeluaran') ? 'has-error' : '' }}">
                <label for="inputWarning" class="col-xs-12 col-sm-3 control-label no-padding-right">Pengeluaran (Rp)</label>
                <div class="col-xs-12 col-sm-5">
                    <span class="block input-icon input-icon-right">
                        <input type="text" class="width-100 form-control" name="pengeluaran" value=0>
                    </span>
                </div>
            </div>

            <div class="form-group{{ $errors->has('keperluan') ? 'has-error' : '' }}">
                <label for="inputWarning" class="col-xs-12 col-sm-3 control-label no-padding-right">Keperluan</label>
                <div class="col-xs-12 col-sm-5">
                    <span class="block input-icon input-icon-right">
                        <textarea class="width-100 form-control" name="keperluan" value="-"></textarea>
                    </span>
                </div>
            </div>

            <div class="form-group">
                <label for="inputWarning" class="col-xs-12 col-sm-3 control-label no-padding-right"></label>
                <div class="col-xs-12 col-sm-5">
                    <span class="block input-icon input-icon-right">
                        <button class="btn btn-success">Add</button>
                    </span>
                </div>
            </div>
        </div>
        </div>
    </div>
</form>
@endsection
