@extends('layout')
@section('judul')
Create Anggota
@endsection
@section('konten')
<div class="row">
	<h3>Create New Anggota</h3>
	<form action="{{ url('profileMVC') }}" method="post" class="form-horizontal">
		{{csrf_field()}}
		<div class="form-group">
			<label class="col-md-4 control-label" for="name">Full Name</label>  
			<div class="col-md-5">
				<input type="text" name="name" placeholder="Full Name" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="sex">Gender</label>
			<div class="col-md-4"> 
				<label class="radio-inline" for="sex-0">
					<input type="radio" name="sex" id="sex-0" value="Male">
					Male
				</label> 
				<label class="radio-inline" for="sex-1">
					<input type="radio" name="sex" id="sex-1" value="Female">
					Female
				</label>
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="idcard">Identity Card Number</label>  
			<div class="col-md-5">
				<input type="text" name="idcard" placeholder="ID Card Number" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="birthdate">Birth Date</label>  
			<div class="col-md-5">
				<input type="text" name="birthdate" id="birthdate" placeholder="Birth Date" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="province">Province</label>  
			<div class="col-md-5">
				<input type="text" name="province" placeholder="Province" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="district">District</label>  
			<div class="col-md-5">
				<input type="text" name="district" placeholder="District" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="sector">Sector</label>  
			<div class="col-md-5">
				<input type="text" name="sector" placeholder="Sector" class="form-control input-md" required="">
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="image">Image</label>  
			<div class="col-md-5">
				<div class="input-group">
					<span class="input-group-btn">
						<label class="btn btn-default btn-file">
							Browse&hellip;<input type="file" style="display: none;" name="image" id="browse">
						</label>
					</span>
					<input type="text" class="form-control input-md" id="i" name="i" placeholder="not file selected" disabled="true">
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="col-md-4 control-label" for="submit"></label>
			<div class="col-md-4">
			<button id="submit" name="submit" class="btn btn-success">Save Anggota</button>
			</div>
		</div>
	</form>
</div>


</section>
@endsection
@section('script')
<script>
	$(document).ready(function(){
		$('#birthdate').datepicker({
			format: "dd/mm/yyyy"
		});
	});
	$(function() {

  // We can attach the `fileselect` event to all file inputs on the page
  $(document).on('change', ':file', function() {
  	var input = $(this),
  	numFiles = input.get(0).files ? input.get(0).files.length : 1,
  	label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
  	input.trigger('fileselect', [numFiles, label]);
  });

		  // We can watch for our custom `fileselect` event like this
		  $(document).ready( function() {
		  	$(':file').on('fileselect', function(event, numFiles, label) {

		  		var input = $(this).parents('.input-group').find(':text'),
		  		log = numFiles > 1 ? numFiles + ' files selected' : label;

		  		if( input.length ) {
		  			input.val(log);
		  		} else {
		  			if( log ) alert(log);
		  		}

		  	});
		  });
		  
		});
	</script>
	@endsection