<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

//Awal
Route::get('/',function(){
    return view('auth.login');
})->middleware('guest');

//Login Pegawai


Route::get('/getImport', 'ExcelController@getImport');
Route::get('/getImportPengunjung', 'ExcelController@getImportPengunjung');
Route::get('/getImportPembayaran', 'ExcelController@getImportPembayaran');

Route::post('/postImport', 'ExcelController@postImport');
Route::post('/postImportPengunjung', 'ExcelController@postImportPengunjung');
Route::post('/postImportPembayaran', 'ExcelController@postImportPembayaran');

Route::get('/getExport', 'ExcelController@getExport');
Route::get('/getExportPembayaran', 'ExcelController@getExportPembayaran');



Route::get('/getPDFKeuangan', 'PDFController@getPDFKeuangan');
Route::get('/getPDFPembayaran', 'PDFController@getPDFPembayaran');

Route::get('/deleteAll', 'ExcelController@deleteAll');
Route::get('/deleteAllPengunjung', 'ExcelController@deleteAllPengunjung');
Route::get('/deleteAllPembayaran', 'ExcelController@deleteAllPembayaran');


// Upload didukung dari Youtube
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)
Route::get('upload', 'UploadsController@index');
Route::post('laporanPegawai/uploadFiles', 'UploadpController@multiple_upload');

Route::get('laporanPegawai', 'UploadpController@index');
Route::post('upload/uploadFiles', 'UploadsController@multiple_upload');

Route::get('laporanKeuanganReceptionist', 'UploadrkController@index');
Route::post('laporanKeuanganReceptionist/uploadFiles', 'UploadrkController@multiple_upload');


Route::get('laporanTransaksiReceptionist', 'UploadrtController@index');
Route::post('laporanTransaksiReceptionist/uploadFiles', 'UploadrtController@multiple_upload');


Route::get('seeupload', 'UploadseeController@index');
Route::post('seeupload/uploadFiles', 'UploadseeController@multiple_upload');

Route::get('seeuploadPegawai', 'UploadseePegawaiController@index');
Route::post('seeuploadPegawai/uploadFiles', 'UploadseePegawaiController@multiple_upload');


Route::get('seeuploadReceptionistKeuangan', 'Uploadsee_rkController@index');
Route::post('seeuploadReceptionistKeuangan/uploadFiles', 'Uploadsee_rkController@multiple_upload');


Route::get('seeuploadReceptionistTransaksi', 'Uploadsee_rtController@index');
Route::post('seeuploadReceptionistTransaksi/uploadFiles', 'Uploadsee_rtController@multiple_upload');



Route::get('verifikasi', 'VerifikasisController@index');
Route::post('verifikasi/uploadFiles', 'VerifikasisController@multiple_upload');


Route::get('verifikasiPengunjung', 'Verifikasis_pController@index');
Route::post('verifikasiPengunjung/uploadFiles', 'Verifikasis_pController@multiple_upload');


Route::get('verifikasiMasalah', 'Verifikasis_mController@index');
Route::post('verifikasiMasalah/uploadFiles', 'Verifikasis_mController@multiple_upload');

Route::get('seeverifikasiKeuangan', 'Verifikasisee_kController@index');
Route::post('seeverifikasiKeuangan/uploadFiles', 'Verifikasisee_kController@multiple_upload');

Route::get('seeverifikasiMasalah', 'Verifikasisee_mController@index');
Route::post('seeverifikasiMasalah/uploadFiles', 'Verifikasisee_mController@multiple_upload');

Route::get('seeverifikasiPengunjung', 'Verifikasisee_pController@index');
Route::post('seeverifikasiPengunjung/uploadFiles', 'Verifikasisee_pController@multiple_upload');




Route::get('verifikasiKeuanganManager', 'Report_kController@index');
Route::post('verifikasiKeuanganManager/uploadFiles', 'Report_kController@multiple_upload');


Route::get('verifikasiMasalahManager', 'Report_mController@index');
Route::post('verifikasiMasalahManager/uploadFiles', 'Report_mController@multiple_upload');


Route::get('verifikasiPengunjungManager', 'Report_pController@index');
Route::post('verifikasiPengunjungManager/uploadFiles', 'Report_pController@multiple_upload');

Route::get('seeReportKeuanganManager', 'Reportsee_kController@index');
Route::post('seeReportKeuanganManager/uploadFiles', 'Reportsee_kController@multiple_upload');

Route::get('seeReportMasalahManager', 'Reportsee_mController@index');
Route::post('seeReportMasalahManager/uploadFiles', 'Reportsee_mController@multiple_upload');

Route::get('seeReportPengunjungManager', 'Reportsee_pController@index');
Route::post('seeReportPengunjungManager/uploadFiles', 'Reportsee_pController@multiple_upload');






Route::get('/seeReportKeuanganManager/{id}/edit', 'Reportsee_kController@edit');
Route::get('profile', 'UserController@profile');

// Routing untuk authentifikasi
Route::group(['namespace' => 'auth'],function(){
	Route::post('/login','LoginController@login')->name('login');
    Route::post('/register','RegisterController@register')->name('register');
    Route::get('/logout',function(){
        Auth::logout();
        return redirect('/');
    })->name('logout');

    //manager
    Route::get('manager/resetpassword','LoginController@resetpass')->name('manager.resetpass')->middleware('manager');
    //pegawai
    Route::get('pegawai/resetpassword','LoginController@resetpass')->name('pegawai.resetpass')->middleware('pegawai');
    //receptionist
    Route::get('receptionist/resetpassword','LoginController@resetpass')->name('receptionist.resetpass')->middleware('receptionist');
    //administrasi
    Route::get('administrasi/resetpassword','LoginController@resetpass')->name('administrasi.resetpass')->middleware('administrasi');

    Route::get('gmaster/resetpassword','LoginController@resetpass')->name('gmaster.resetpass')->middleware('gmaster');

   
    Route::post('resetpassword','LoginController@reset')->name('reset');

    Route::get('query','CariController@search');









});

// Routing untuk user level manager
Route::group(['namespace' => 'backend','prefix' => 'manager','middleware' => 'manager'], function() {
    // Controllers Within The "App\Http\Controllers\manager" Namespace

   
    Route::get('/', function () {
	    return view('backend.dashboard',['title' => 'Dashboard']);
	})->name('manager');
   



    Route::resource('pegawai','PgwCtrl');
    Route::resource('receptionist','RctCtrl');
    Route::resource('administrasi','AdmCtrl');
    Route::resource('gmaster','GmCtrl');
   
});

// Routing untuk user level pegawai
Route::group(['namespace' => 'pegawai','prefix' => 'pegawai','middleware' => 'pegawai'], function() {
    Route::get('/', function () {
        return view('pegawai.dashboard',['title' => 'Dashboard']);
    })->name('pegawai');

});


Route::group(['namespace' => 'receptionist','prefix' => 'receptionist','middleware' => 'receptionist'], function() {
    Route::get('/', function () {
        return view('receptionist.dashboard',['title' => 'Dashboard']);
    })->name('receptionist');

});

Route::group(['namespace' => 'administrasi','prefix' => 'administrasi','middleware' => 'administrasi'], function() {
    Route::get('/', function () {
        return view('administrasi.dashboard',['title' => 'Dashboard']);
    })->name('administrasi');

});


Route::group(['namespace' => 'gmaster','prefix' => 'gmaster','middleware' => 'gmaster'], function() {
    Route::get('/', function () {
        return view('gmaster.dashboard',['title' => 'Dashboard']);
    })->name('gmaster');

});


// CRUD buku didukung dari Youtube
//https://www.youtube.com/watch?v=H_T-2ClHvJY











Route::group(['middleware' => 'manager'], function () {
      Route::resource('seeupload', 'UploadseeController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'manager'], function () {
      Route::resource('seeverifikasiKeuangan', 'Verifikasisee_kController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'manager'], function () {
      Route::resource('seeverifikasiMasalah', 'Verifikasisee_mController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'manager'], function () {
      Route::resource('seeverifikasiPengunjung', 'Verifikasisee_pController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'manager'], function () {
      Route::resource('verifikasiKeuanganManager', 'Report_kController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'manager'], function () {
      Route::resource('verifikasiMasalahManager', 'Report_mController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'manager'], function () {
      Route::resource('verifikasiPengunjungManager', 'Report_pController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});







Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('pengunjung', 'PengunjungController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('pembayaran', 'PembayaranController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('laporanKeuangan', 'laporanKeuanganController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('laporanPengunjung', 'laporanPengunjungController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});



Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('tampilkandata', 'PembayaranController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('pdf', 'PDFController@showPDF');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});




Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('kamar', 'KamarController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('upload', 'UploadsController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('laporanKeuanganReceptionist', 'UploadrkController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'receptionist'], function () {
      Route::resource('laporanTransaksiReceptionist', 'UploadrtController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});



Route::group(['middleware' => 'pegawai'], function () {
      Route::resource('laporanPegawai', 'UploadpController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});






// Upload didukung dari Video
//Judul Video adalah Laravel 5.3, 5.2 - Download Files From Database (.pdf,.doc,.png,.jpg,.xlsl etc)(360p)


Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeupload', 'UploadseeController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});



Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeuploadReceptionistKeuangan', 'Uploadsee_rkController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeuploadReceptionistTransaksi', 'Uploadsee_rtController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('seeuploadPegawai', 'UploadseePegawaiController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});



Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('verifikasi', 'VerifikasisController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('verifikasiPengunjung', 'Verifikasis_pController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});

Route::group(['middleware' => 'administrasi'], function () {
      Route::resource('verifikasiMasalah', 'Verifikasis_mController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});



Route::group(['middleware' => 'gmaster'], function () {
      Route::resource('seeReportKeuanganManager', 'Reportsee_kController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'gmaster'], function () {
      Route::resource('seeReportMasalahManager', 'Reportsee_mController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::group(['middleware' => 'gmaster'], function () {
      Route::resource('seeReportPengunjungManager', 'Reportsee_pController');    
//        // Uses Auth Middleware
//    });

    //Please do not remove this if you want managerlte:route and managerlte:link commands to works correctly.
    #managerlte_routes
});


Route::get('/home', 'HomeController@index');

Route::get('pagenotfound', ['as'=> 'notfound', 'uses' => 'HomeController@pagenotfound']);
