<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username', 'email', 'password','role'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $casts = [
        'role' => 'string',
    ];

      public function manager(){
        return $this->belongsTo('App\Models\Manager','id','user_id');
    }

    public function pegawai(){
        return $this->belongsTo('App\Models\Pegawai','id','user_id');
    }

    public function receptionist(){
        return $this->belongsTo('App\Models\Receptionist','id','user_id');
    }

    public function administrasi(){
        return $this->belongsTo('App\Models\Administrasi','id','user_id');
    }

    public function gmaster(){
        return $this->belongsTo('App\Models\Gmaster','id','user_id');
    }


}
