<?php

namespace App\Http\Controllers;



use App\Http\Request;
use App\Http\Controllers\Controller;
use App\Book;
use Illuminate\Support\Facades\Input;
use DB;
use Excel;

class ExcelController extends Controller
{
    public function getImport(){
    	return view('excel.importBuku');
    }

    public function postImport(){

    	Excel::load(Input::file('book'),function($reader){
    		$reader->each(function($sheet){
    			Book::firstOrCreate($sheet->toArray());
    		});
    	});

        $books = Book::all();
        return view('book.index',['books' => $books]);
    }

    public function deleteAll(){
        DB::table('tbl_book')->delete();
        $books = Book::all();
        return view('book.index',['books' => $books]);
    }

    public function getExport(){
        $book=Book::all();
        Excel::create('Export Data', function($excel) use($book){
            $excel->sheet('Sheet 1', function($sheet) use($book){
                $sheet->fromArray($book);
            });
        })->export('xlsx');
    }
}
