@extends('layouts.layout')

@section('content')
<div class="col-md-12">
    <div class="card">
        <div class="header">
	        <h4 class="title">{{$title}}</h4>
	        <p class="category"></p>
	    </div>
	    <div class="content">
	    	<form action="{{route('pegawai.update',$pegawai->id)}}" method="POST">
	    	{{ csrf_field() }}
	    	<input type="hidden" name="mhs_id" value="$pegawai->id">
	    	<input type="hidden" name="_method" value="PUT">
	    	<div class="row">
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('nip')) has-error @endif"">
	                    <label>NIP</label>
	                    <input type="text" class="form-control border-input" value="{{$pegawai->nip}}" name="nip">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('nip')}}</span>
	                </div>
	            </div>
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('tahun_masuk')) has-error @endif"">
	                    <label>Tahun masuk</label>
	                    <input type="text" class="form-control border-input" value="{{$pegawai->tahun_masuk}}" name="tahun_masuk">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('tahun_masuk')}}</span>
	                </div>
	            </div>
            </div>
            <div class="row">
		    	<div class="col-md-10">
	                <div class="form-group @if($errors->has('nama_pegawai')) has-error @endif"">
	                    <label>Nama pegawai</label>
	                    <input type="text" class="form-control border-input" value="{{$pegawai->nama_pegawai}}" name="nama_pegawai">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('nama_pegawai')}}</span>
	                </div>
	            </div>
            </div>
            <div class="row">
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('jabatan')) has-error @endif"">
	                    <label>Jabatan</label>
	                    <select class="form-control border-input" name="jabatan">
	                    	@foreach($jabatan as $jur)
	                    	<option value="{{$jur}}" {{$pegawai->jabatan == $jur ? 'selected' : ''}}>{{$jur}}</option>
	                    	@endforeach
	                    </select>
	                    <span id="helpBlock2" class="help-block">{{$errors->first('jabatan')}}</span>
	                </div>
	            </div>
            </div>
            
            <div class="row">
            	<div class="col-md-12">
            		<a href="{{ route('pegawai.index') }}" class="btn btn-default">Cancel</a>
					<input type="submit" class="btn btn-default">
            	</div>
            </div>
	    	</form>
	    </div>
    </div>
</div>
@endsection